// Effects on Stability.
// G(s) = a^2 / s(s+2b a) , H(s) = C , T(s) = C a^2 / ( s(s+2b a) + C a^2 )
s=%s;
t=0:0.01:10;
a=1;b=1;
C=[1,2,5,10] 
for n=1:4
    T=syslin('c', C(n)*a^2 , s*(s + 2*b*a) + C(n)*a^2 );
    Ts=csim('step',t,T);
    xset("line style",n);
    plot2d(t,Ts);   
    xgrid(5); 
end
xtitle('Effects on Stability .','Time(sec)','C(t)');
legends(['C=1';'C=2';'C=5';'C=10';],[[1;1],[1;2],[1;3],[1;4]], opt=4);


